GitLab libvirt Executor
=======================

Custom [GitLab Runner](https://docs.gitlab.com/runner/) executor to run jobs inside ephemeral [libvirt](https://libvirt.org/) virtual machines.

![gitlab-libvirt-executor](assets/gitlab-libvirt-executor.svg)

# Features


- builds are executed within isolated VMs
- VMs are ephemeral (cloned on the fly from a reference VM, and destroyed after the job terminated)
- cloning is very fast (using COW)
- multiple VM images supported


# Running

## Prerequisites

Under the hood, `gitlab-libvirt-executor` uses libvirt (both the `virsh` client application and the libvirt Python bindings).
For fast cloning of QCOW2 images, it requires the `qemu-img` utility.

On Debian systems, the required cmdline utilities can be installed via:

```sh
apt-get install qemu-utils libvirt-clients
```

If you want to install all Python dependencies automatically via `pip`, you will also need to install the `libvirt` development files:

```sh
apt-get install build-essential libvirt-dev
```

You can also choose to use system installed Python packages, in which case you would need to install the following instead:

```sh
apt-get install python3-libvirt python3-paramiko
```


## Installation

```
pip install git+https://git.iem.at/zmoelnig/gitlab-libvirt-executor.git
```

(To use the system-installed dependencies use `pip install --no-deps git+https://git.iem.at/zmoelnig/gitlab-libvirt-executor.git`)



## Configuration


#### gitlab-runner

Tell `gitlab-runner` to use the custom executor:

```toml
[[runners]]
  # ...
  builds_dir = "/home/vagrant/build"
  cache_dir = "/home/vagrant/cache"
  executor = "custom"

  [runners.custom]
    config_exec = "gitlab-libvirt-executor"
    config_args = [ "config" ]
    prepare_exec = "gitlab-libvirt-executor"
    prepare_args = [ "prepare" ]
    run_exec = "gitlab-libvirt-executor"
    run_args = [ "run" ]
    cleanup_exec = "gitlab-libvirt-executor"
    cleanup_args = [ "cleanup" ]
```

#### gitlab-libvirt-executor

`gitlab-libvirt-executor` looks for INI-style configuration files in
- `/etc/gitlab-runner/gitlab-libvirt-executor.ini`
- `~/.config/gitlab-runner/gitlab-libvirt-executor.ini` (in the home directory of the user running `gitlab-libvirt-executor`)

You can specify a different configuration file via the `--config` flag.

```ini
[DEFAULT]
# how to connect to the libvirt daemon
connect = qemu:///system

# ###### global settings ######

# only allow VMs that are explicitly configured (the default),
# or any VM libvirt knows about
exclude-unconfigured = true


# ###### defaults for the VMs ######

# ssh credentials
username = vagrant
password = vagrant

# ###### VMs configurations ######

[debian12]
# use the 'debian12' VM
# inherit all settings from the DEFAULT section
# except for those explicitly specified here
timeout = 300

[debian]
# extends the debian12' VM (inheriting all settings recursively), so
# - the 'debian12' disk image is use
# - any overrides from te debian12' section are used (e.g. timeout)
# this is a nice alias for the 'debian12' image
extends = debian12
# override the 'timeout' from the base VM
timeout = 60
```


Now you can use libvirt VMs in your `.gitlab-ci.yml`:

```yml
# You can use any libvirt VM the executor knows about
image: debian

test:
  # In case you tagged runners that have
  # GitLab Libvirt Executor configured on them
  tags:
    - libvirt-installed

  script:
    - uname -a
```


# Caveats

- VMs must already exist on the libvirt hypervisor (it is not possible to pull VMs from remote servers,
  like `vagrant` or `tart` or `docker`)
- While it is possible to connect to any libvirt daemon (local or remote),
  cloning VMs currently only works with local images

# Literature

- [Using libvirt with the Custom executor](https://docs.gitlab.com/runner/executors/custom_examples/libvirt.html)
- [GitLab Tart Executor](https://github.com/cirruslabs/gitlab-tart-executor/)
