#include "sophie.h"

/* If we start failing while opening dirs, something went wrong - let's try to catch it and abort */
int failopencounter = 0;


/* Partially 'borrowed' from lstree.c program which I found on the web - was lazy to reinvent a wheel (recursion ;) */
static int sophie_scandir_sub(char *dirpath, int *error_occurred)
{
	int ret;
	DIR *dirpt;
	struct dirent *direntry;
	struct stat filestat;
	char path[MAXPATHLEN];
	
	/* We don't need trailing slash, do we? */
	/* Now, don't put 10 trailing slashes, please... ;) */
	if ( (dirpath[strlen(dirpath)-1] == '/') && (strlen(dirpath) > 1) )
		dirpath[strlen(dirpath)-1] = '\0';

	if (!(dirpt = opendir(dirpath)))
	{
		failopencounter++;
		sophie_print(0, "%s Could not open dir (%s)", WARNSTR, dirpath);
		
		if (failopencounter >= 20)
		{
			snprintf(ret_error_string, sizeof(ret_error_string)-1, "opendir() failed for '%s' (too many failures)", dirpath);
			return(-1);
		}
		else
		{
			snprintf(ret_error_string, sizeof(ret_error_string)-1, "opendir() failed for '%s' (%s)", dirpath, strerror(errno));
			return(-1);
		}
	}	

	while ((direntry = readdir(dirpt)))
	{
		/* skip . and .. directories */
		if (strcmp(direntry->d_name, ".") == 0 ||
		    strcmp(direntry->d_name, "..") == 0) 
			continue;

		memset(path, 0, sizeof(path));
		strncat(path, dirpath, sizeof(path)-1);
		strncat(path, "/", sizeof(path)-1);
		strncat(path, direntry->d_name, sizeof(path)-1);
		
		stat(path, &filestat);
		
		/* We do regular files... */
		/* FIXME - S_ISLNK(m) doesn't return 1 even if I point it to the symlink - no idea why, and too tired to fight with it - FIXME */
		if (S_ISREG(filestat.st_mode))
		{
			/* 
				Just additional protection against stupid /proc entries (in case we somehow get in there)
				Anyway, we don't want to scan 0 sized files, do we? (I might be missing something big :)
			*/
			if (filestat.st_size != 0)
			{
				/*
					Argh... there must be a better way to get rid of /proc/self, /dev/fd/... (and other) stuff
					It's 4am, and I'm not going to look for better way... someone tell me better way ;)
				*/
				if ( (!strstr(path, "proc/self/")) || (!strstr(path, "dev/fd/")) )
				{
					/* If virus was found - return 1 */
					ret = sophie_scanfile(path);
					if (ret > 0) {
						/* virus found, abort now */
						closedir(dirpt);
						return(1);
					}
					else if (ret < 0) {
						/* error found, just update remember we it occurred,
						but continue scanning since they still may be a virus */
						*error_occurred = 1;
					}
				}
			}
			else
			{
				sophie_print(1, "%s Scan of 0 sized file was requested - we refused it", NOTESTR);
			}
		}
		
		/* And we do dirs... */
		if (S_ISDIR(filestat.st_mode))
		{
			/*
				This might be complete nonsense. This is just checking if number of blocks
				on the filesystem is > 0 (so that /proc/self doesn't get caught, fe ;),
				and if it is - scans it
			*/
			if (filestat.st_blocks > 0)
				if ((sophie_scandir_sub(path, error_occurred)) > 0) {
					closedir(dirpt);
					return(1); /* virus found */
				}
		}
	}

	/* We finished w/o problems (or viruses) - return 0 */
	closedir(dirpt);
	return (*error_occurred != 0) ? -1 : 0;
}

int sophie_scandir(char *dirpath)
{
	int error_occurred = 0;	
	/* call sophie_scandir_sub to perform the scan.  sophie_scandir_sub
	   will update error_occurred if an error is found */
	return sophie_scandir_sub(dirpath, &error_occurred);
}
