#include "sophie.h"

void *new_CISaviNotify(void);

static HRESULT SOPHOS_STDCALL SOPHOS_PUBLIC 
		CISaviNotify_QueryInterface (void *object, 
			REFIID IIDObject, void **ppObject);

static SOPHOS_ULONG SOPHOS_STDCALL SOPHOS_PUBLIC
		CISaviNotify_AddRef (void *object);

static SOPHOS_ULONG SOPHOS_STDCALL SOPHOS_PUBLIC 
		CISaviNotify_Release (void *object);

static HRESULT SOPHOS_STDCALL SOPHOS_PUBLIC 
		CISaviNotify_OkToContinue (void *object, void *token, 
			U16 Activity, U32 Extent, LPCOLESTR pTarget);

/* Assign callbacks */
/*static const CISweepNotify2Vtbl CISaviNotifyVtbl_Instance =
{
  CISaviNotify_QueryInterface,
  CISaviNotify_AddRef,
  CISaviNotify_Release,
  CISaviNotify_OnFileFound,
  CISaviNotify_OnVirusFound,
  CISaviNotify_OnErrorFound,
  CISaviNotify_OkToContinue,
  CISaviNotify_OnClassification
};
*/
static const CISweepNotify2Vtbl CISaviNotifyVtbl_Instance =
{
  CISaviNotify_QueryInterface,
  CISaviNotify_AddRef,
  CISaviNotify_Release,
  NULL,
  NULL,
  NULL,
  CISaviNotify_OkToContinue,
  NULL
};

int SetNotification(CISavi3 *pSAVI, void *token)
{
	CISweepNotify2 *pNotify = NULL;
	int retVal = 0;
	HRESULT hr;

	if (!pSAVI)
	{
    	sophie_print(0, "%s SetNotification() called with incorrect parameters", WARNSTR);
		return(0);
	}

	/*
	 * Attempt to create a new notification interface.
	 */
	pNotify = new_CISaviNotify();
	if (!pNotify)
	{
	    sophie_print(0, "%s Could not create notification interface", WARNSTR);
	    return(0);
	}

	/*
	 * Register the notification interface with SAVI.
	 */
	hr = pSAVI->pVtbl->RegisterNotification(pSAVI, &SOPHOS_IID_SWEEPNOTIFY2, 
												pNotify, token);

	/*
	 * Find out if SAVI accepted the notification interface.
	 */
	if (SOPHOS_FAILED(hr))
		sophie_print(0, "%s Could not register notification interface with SAVI. [0x%08lx]", WARNSTR, (unsigned long) hr);
	else
		retVal = 1;

	/*
	 * Release our local pointer to the notification object.
	 * This will not destroy the object because SAVI added a reference
	 * when we called RegisterNotification.
	 */
	pNotify->pVtbl->Release(pNotify);

	return retVal;
}

void *new_CISaviNotify(void)
{
	CISweepNotify2 *INTobject;

	if ( (INTobject = (CISweepNotify2 *) malloc(sizeof(CISweepNotify2))) == NULL)
		return NULL;

	INTobject->typeCode = SOPHOS_IID_SWEEPNOTIFY2;
	INTobject->refCount = 1;
	INTobject->pVtbl = (CISweepNotify2Vtbl*) &CISaviNotifyVtbl_Instance;

	return((void *) INTobject);
}

static void delete_CISaviNotify(void *object)
{
	CISweepNotify2 *INTobject = (CISweepNotify2 *) object;

	if ( (!object) || !IsEqualIID(&INTobject->typeCode, &SOPHOS_IID_SWEEPNOTIFY2) )
		return;

	if (object)
		free(object);
}

static HRESULT SOPHOS_STDCALL SOPHOS_PUBLIC 
	CISaviNotify_QueryInterface(void *object, REFIID IIDObject, void **ppObject)
{
	CISweepNotify2 *INTobject = (CISweepNotify2 *) object;
	HRESULT retCode;

	if ((!object) || (!IIDObject) || (!ppObject) || !IsEqualIID(&INTobject->typeCode, &SOPHOS_IID_SWEEPNOTIFY2))
		return(SOPHOS_E_INVALIDARG);

	if (!IsEqualIID(IIDObject, &SOPHOS_IID_UNKNOWN2) && !IsEqualIID(IIDObject, &INTobject->typeCode))
		return(SOPHOS_E_NOINTERFACE);

	retCode = ((SOPHOS_FAILED(INTobject->pVtbl->AddRef(object))) ? SOPHOS_E_UNEXPECTED : SOPHOS_S_OK);

	*ppObject = ((retCode == SOPHOS_S_OK) ? object : NULL);
	
	return(retCode);
}

static SOPHOS_ULONG SOPHOS_STDCALL SOPHOS_PUBLIC 
	CISaviNotify_AddRef(void *object)
{
	CISweepNotify2 *INTobject = (CISweepNotify2 *) object;

	if ((!object) || !IsEqualIID(&INTobject->typeCode, &SOPHOS_IID_SWEEPNOTIFY2))
		return (SOPHOS_ULONG) SOPHOS_E_INVALIDARG;

	if (INTobject->refCount == 0x7FFFFFFF)
		return (SOPHOS_ULONG) SOPHOS_E_UNEXPECTED;

	return(++(INTobject->refCount));
}

static SOPHOS_ULONG SOPHOS_STDCALL SOPHOS_PUBLIC 
	CISaviNotify_Release(void *object)
{
	CISweepNotify2 *INTobject = (CISweepNotify2 *) object;
	SOPHOS_ULONG retCode;

	if ((!object) || !IsEqualIID(&INTobject->typeCode, &SOPHOS_IID_SWEEPNOTIFY2))
		return (SOPHOS_ULONG)SOPHOS_E_INVALIDARG;

	if (INTobject->refCount > 0)
		INTobject->refCount--;

	retCode = INTobject->refCount;

	if (retCode == 0)
		delete_CISaviNotify(object);

	return(retCode);
}

/*
 * Function: OkToContinue
 *
 * Parameters: (1) pointer to host notify interface.
 *             (2) pointer to the token provided at registration
 *                 time.
 *             (3) current scanning activity
 *             (4) extent of current scanning activity
 *             (5) the name of the object being scanned
 *
 * Returns: SOPHOS_SAVI_CBCK_CONTINUE_THIS
 *          SOPHOS_SAVI_CBCK_CONTINUE_NEXT
 *          SOPHOS_SAVI_CBCK_STOP
 *          SOPHOS_SAVI_CBCK_DEFAULT
 *          SOPHOS_E_INVALIDARG
 *
 * Purpose: Is placed in the notification interface to enable
 *          SAVI to call the client back during scanning so that
 *          the client can take a decision to abort the scan if it
 *          decides that the scan is taking too many resources
 *          (memory, disc, processing time etc.)
 */
static HRESULT SOPHOS_STDCALL SOPHOS_PUBLIC 
  CISaviNotify_OkToContinue (void *object, void *token, 
                             U16 Activity, U32 Extent, LPCOLESTR pTarget)
{
	static int loop_classif = 0;
	static int loop_nextfile = 0;
	static int loop_decompr = 0;

/*	CISweepNotify *INTobject = (CISweepNotify *) object; */
	HRESULT ret = SOPHOS_SAVI_CBCK_DEFAULT;

	/* Check if the remote socket is still connected */
	fd_set fds;
	struct timeval tv;
	int select_res;

	/* Notification struct */
	struct sophie_notification *item;
	item = (struct sophie_notification *) token;

	/* select() check... */
	if (config.socket_check)
	{
		FD_ZERO(&fds);
		FD_SET(item->socket, &fds);
		tv.tv_sec = 0;
		tv.tv_usec = 0;
		select_res = select(item->socket+1, &fds, NULL, NULL, &tv);

		/* FIXME... maybe?
		   Now, this is very silly. If socket gets disconnected
		   on client side, res will contain '1', and attempt to read
		   from it will return 0 - this way I *ASSUME* that client
		   is really gone...

		   The problem is that it seems to work, but I'm not 100%
		   sure if this is the right way...
		*/
		if (select_res > 0)
		{
			char maja;
			int mret;
			mret = read(item->socket, &maja, 1);
			item->interrupted = 1;
			strncpy(item->message, "Remote socket disconnected.", sizeof(item->message));
			return(SOPHOS_SAVI_CBCK_STOP);
		}
	}

/*printf("d: [%d], n: [%d], c: [%d]\n", loop_decompr, loop_nextfile, loop_classif);*/

	/* Scanning checks... */
	if (loop_classif >= config.limit_classif)
	{
		sophie_print(0, "%s loop_classif_limit reached (%d) with file '%s' - aborting", NOTESTR, config.limit_classif, pTarget);
		strncpy(item->message, "Notification loop_classif_limit reached.", sizeof(item->message)-1);
		item->interrupted = 1;
		return(SOPHOS_SAVI_CBCK_STOP);
	}

	if (loop_nextfile >= config.limit_nextfile)
	{
		sophie_print(0, "%s loop_nextfile_limit reached (%d) with file '%s' - aborting", NOTESTR, config.limit_nextfile, pTarget);
		strncpy(item->message, "Notification loop_nextfile_limit reached.", sizeof(item->message)-1);
		item->interrupted = 1;
		return(SOPHOS_SAVI_CBCK_STOP);
	}

	if (loop_decompr >= config.limit_decompr)
	{
		sophie_print(0, "%s loop_decompr_limit reached (%d) with file '%s' - aborting", NOTESTR, config.limit_decompr, pTarget);
		strncpy(item->message, "Notification loop_decompr_limit reached.", sizeof(item->message)-1);
		item->interrupted = 1;
		return(SOPHOS_SAVI_CBCK_STOP);
	}

	if (pTarget)
	{
		switch (Activity)
		{
			case SOPHOS_ACTVTY_CLASSIF:
			loop_classif++;
			break;

			case SOPHOS_ACTVTY_NEXTFILE:
			loop_nextfile++;
			break;

			case SOPHOS_ACTVTY_DECOMPR:
			loop_decompr++;
			break;

			default:
			sophie_print(0, "%s Callback error occured with file '%s'", WARNSTR, pTarget);
			ret = SOPHOS_SAVI_ERROR_CALLBACK;
			break;
		}
	}
	else 
	{
		sophie_print(0, "%s NULL file name supplied in CISaviNotify_OkToContinue()", WARNSTR);
	}

	return(ret);
}
