#include <sys/types.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <stdio.h>
#include <dirent.h>
#include <unistd.h>
#include <stdlib.h>
#include <wait.h>
#include <string.h>

#define MAX_PROC	10

/*
  This program reads a file (line-by-line) that contains list of files
  which should be scanned by Sophie.
  
  This can be used for testing the stability and resource usage.
  
  For example, create a file by doing  (will take a while ;):
  
  # find / -type f > FILELIST
  
  Then use fsock with:
  
  # ./fsock <sophie_socket> FILELIST
 */

char sockname[256];
int check(char *path);

int main(int argc, char *argv[])
{
	int PROC_COUNT = 0;
	char buf[256];
	char filelist[256];
	pid_t pid;
	FILE *fp;
	
	if (argc != 3)
	{
		printf("Usage: %s <socket> <filename_with_filelist>\n", argv[0]);
		exit(1);
	}
	
	sockname[0] = '\0';
	filelist[0] = '\0';

	strncpy(sockname, argv[1], sizeof(sockname)-1);
	strncpy(filelist, argv[2], sizeof(filelist)-1);
	
	if ((fp = fopen(filelist, "r")) == NULL)
	{
		perror("fopen");
		exit(1);
	}

	while(fgets(buf, sizeof(buf), fp))
	{
			if ((pid = fork()))
			{
				pid_t wait_pid;
				/* parent */

				PROC_COUNT++;
				if (PROC_COUNT >= MAX_PROC)
				{
					wait_pid = wait(NULL);
					if (wait_pid > 0)
					{
						PROC_COUNT--;
					}
				}
				continue;
			}
			else
			{
				check(buf);
				exit(0);
			}
		exit(0);
	}

	exit(0);

}

int check(char *path)
{
	int sock;
	struct sockaddr_un server;
	char buf[256];
	int bread;

	/* Create socket */
	sock = socket(AF_UNIX, SOCK_STREAM, 0);
	if (sock < 0)
	{
		perror("socket");
		exit(1);
	}
	/* Connect socket using name specified by command line. */
	server.sun_family = AF_UNIX;
	strcpy(server.sun_path, sockname);

	if (connect(sock, (struct sockaddr *) &server, sizeof(struct sockaddr_un)) < 0)
	{
		close(sock);
		perror("connect");
		exit(1);
	}

	if (write(sock, path, strlen(path)) < 0)
		perror("write");
	
	memset(buf, 0, sizeof(buf));
	if ((bread = read(sock, buf, sizeof(buf))) > 0)
	{
		if (strchr(buf, '\n'))
			*strchr(buf, '\n') = '\0';

		if (strchr(path, '\n'))
			*strchr(path, '\n') = '\0';

		if (buf[0] == '1')
		{
			char *vname = buf+2;
			printf("FILE INFECTED  : [%s] (VIRUS: %s)\n", path, vname);
		}
		else if (!strncmp(buf, "-1", 2))
		{
			char *msg;
			if (strlen(buf) > 3)
			{
				msg = buf+3;
				printf("UNKNOWN STATUS : [%s] (%s)\n", path, msg);
			}
			else
			{
				printf("UNKNOWN STATUS : [%s]\n", path);
			}
		}
		else
			printf("FILE OKAY      : [%s]\n", path);
	}
	else
	{
		printf("*** Argh - failed to read response from Sophie\n");
	}

	close(sock);
	return(0);
}
